#################################################
# Plot T-test results
#################################################

setwd("M:/DataAnalysis/_Reports/EX00660 (Red squirrels age related changes)/A003 - Untargeted/Raw data/PF")

library(ggplot2)
library(reshape2)
library(plyr)
library(dplyr)

boxpf <- function(x){
  if(nrow(x) > 0){
    p <- ggplot(x, aes(as.factor(AGE), AREA, fill = AGE))+ geom_boxplot() + geom_point()  + ggtitle(x$TARGET[[1]])
    p
  }
}

# Negative mode
data.neg <- read.delim("EX00660-PF-NEG-AGE-T-tes-uncorrectedt.txt", check.names=FALSE)
design.neg <- read.delim("EX00660-NEG-design.txt", check.names=FALSE)
data.neg <- inner_join(design.neg, data.neg, by = "File")
data.neg.m <- melt(data.neg, id.vars = c("File", "SEX", "AGE"), variable.name = "TARGET", value.name = "AREA", na.rm = F)
data.neg.m.s <- split(data.neg.m, data.neg.m$TARGET)

pdf("EX00660_NEG_TTEST_BOXPLOT.pdf", onefile = T)
lapply(data.neg.m.s, boxpf)
dev.off()

# Positive mode
data.pos <- read.delim("EX00660-PF-POS-AGE-T-tes-uncorrectedt.txt", check.names=FALSE)
design.pos <- read.delim("EX00660-POS-design.txt", check.names=FALSE)
data.pos <- inner_join(design.pos, data.pos, by = "File")
data.pos.m <- melt(data.pos, id.vars = c("File", "SEX", "AGE"), variable.name = "TARGET", value.name = "AREA", na.rm = F)
data.pos.m.s <- split(data.pos.m, data.pos.m$TARGET)

pdf("EX00660_POS_TTEST_BOXPLOT.pdf", onefile = T)
lapply(data.pos.m.s, boxpf)
dev.off()


